import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [30, 20, 25, 10, 8, 7]
labels = [
    "Coal\n30%",
    "Natural Gas\n20%",
    "Renewables\n25%",
    "Nuclear\n10%",
    "Hydro\n8%",
    "Oil\n7%",
]
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(6, 6))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.8,
    text_kwargs={"fontsize": 12, "color": "black"},
    pad=True,
    ec="black",
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig('tree_5.pdf', bbox_inches='tight')
