# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [27.00, 23.00, 16.00, 12.00, 9.00, 7.00, 4.00, 2.00]
platforms = [
    "Netflix\n27.00%",
    "Spotify\n23.00%",
    "Disney+\n16.00%",
    "Hulu\n12.00%",
    "Prime Video\n9.00%",
    "HBO Max\n7.00%",
    "Apple TV+\n4.00%",
    "Peacock\n2.00%",
]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#66c2a5", # Netflix
    "#fc8d62", # Spotify
    "#8da0cb", # Disney+
    "#e78ac3", # Hulu
    "#a6d854", # Prime Video
    "#ffd92f", # HBO Max
    "#e5c494", # Apple TV+
    "#b3b3b3", # Peacock
]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=market_shares, label=platforms, color=colors, alpha=0.8, text_kwargs={"fontsize": 18}
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig('tree_7.pdf', bbox_inches='tight')