
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# raw data
# data for meteorite impacts
meteorite_data = np.array(
    [
        np.random.rand(17) * 0.5,  # x-coordinates
        np.random.rand(17) * 0.3 + 0.4,  # y-coordinates
        np.random.rand(17) * 0.6 + 0.3,  # z-coordinates
    ]
)

# data for earthquake epicenters
earthquake_data = np.array(
    [
        np.random.rand(17) * 0.6 + 0.4,  # x-coordinates
        np.random.rand(17) * 0.3,  # y-coordinates
        np.random.rand(17) * 0.5 + 0.5,  # z-coordinates
    ]
)
xlabel = "Longitude"
ylabel = "Latitude"
zlabel = "Depth"
labels = ["Meteorite Impacts", "Earthquake Epicenters"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# data preparation
x_meteorite = meteorite_data[0]
y_meteorite = meteorite_data[1]
z_meteorite = meteorite_data[2]

x_earthquake = earthquake_data[0]
y_earthquake = earthquake_data[1]
z_earthquake = earthquake_data[2]

fig, ax = plt.subplots(figsize=(10, 8), subplot_kw={"projection": "3d"})

radius = 1
ax.set_xlim3d([0, radius])
ax.set_ylim3d([0, radius])
ax.set_zlim3d([0, radius * 1.5])
ax.view_init(elev=20.0, azim=60)
ax.dist = 8

# 3D scatter
ax.scatter3D(x_meteorite, y_meteorite, z_meteorite, color="forestgreen", label=labels[0], marker='o')

# draw the path
# hypothetical meteorite trajectory
ax.plot(x_meteorite[0:4], y_meteorite[0:4], z_meteorite[0:4], ls="-", color="green")
ax.plot(x_meteorite[4:8], y_meteorite[4:8], z_meteorite[4:8], ls="-", color="chartreuse")
ax.plot(x_meteorite[8:12], y_meteorite[8:12], z_meteorite[8:12], ls="-", color="lime")
ax.plot(x_meteorite[12:], y_meteorite[12:], z_meteorite[12:], ls="-", color="lawngreen")

# second dataset: earthquake epicenters
ax.scatter3D(x_earthquake, y_earthquake, z_earthquake, color="royalblue", label=labels[1], marker='^')

# hypothetical earthquake fault lines
ax.plot(x_earthquake[0:4], y_earthquake[0:4], z_earthquake[0:4], ls="-", color="blue")
ax.plot(x_earthquake[4:8], y_earthquake[4:8], z_earthquake[4:8], ls="-", color="dodgerblue")
ax.plot(x_earthquake[8:12], y_earthquake[8:12], z_earthquake[8:12], ls="-", color="deepskyblue")
ax.plot(x_earthquake[12:], y_earthquake[12:], z_earthquake[12:], ls="-", color="skyblue")

# labels and grid
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.grid(True)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_22.pdf", bbox_inches="tight")
