
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Hypothetical popularity function for TV shows and movies
def tv_show_popularity(x, y):
    return np.sin(np.pi * x) * np.cos(np.pi * y)

def movie_popularity(x, y):
    return np.cos(np.pi * x) * np.sin(np.pi * y)

# Create a grid of points
x = np.linspace(-1, 1, 100)
y = np.linspace(-1, 1, 100)
x, y = np.meshgrid(x, y)
z1 = tv_show_popularity(x, y)
z2 = movie_popularity(x, y)

# Axes Limits and Labels
ax1_title = "TV Show Popularity"
ax2_title = "Movie Popularity"
xlabel = "Time"
ylabel = "Viewership"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure with specified size
fig = plt.figure(figsize=(12, 6))

xlim_values = np.linspace(-1, 1, 9)
ylim_values = np.linspace(-1, 1, 9)

# First subplot
ax1 = fig.add_subplot(121, projection="3d")
ax1.plot_surface(x, y, z1, cmap="plasma", edgecolor='none')
ax1.set_title(ax1_title)
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_xticks(xlim_values)
ax1.set_xticklabels(xlim_values, rotation=45)
ax1.set_yticks(ylim_values)
ax1.set_yticklabels(ylim_values, rotation=0)

# Second subplot
ax2 = fig.add_subplot(122, projection="3d")
ax2.plot_surface(x, y, z2, cmap="viridis", edgecolor='none')
ax2.set_title(ax2_title)
ax2.set_xlabel(xlabel)
ax2.set_ylabel(ylabel)
ax2.set_xticks(xlim_values)
ax2.set_xticklabels(xlim_values, rotation=45)
ax2.set_yticks(ylim_values)
ax2.set_yticklabels(ylim_values, rotation=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("3d_25.pdf", bbox_inches="tight")
