
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)

# Temperature (°C) values, ranging from 10°C to 35°C
temperature = np.array(
    [
        [10, 15, 20, 25, 30, 35],
        [10, 15, 20, 25, 30, 35],
        [10, 15, 20, 25, 30, 35],
        [10, 15, 20, 25, 30, 35],
        [10, 15, 20, 25, 30, 35],
        [10, 15, 20, 25, 30, 35],
    ]
)

# Elevation (m) values, ranging from 0m to 2000m
elevation = np.array(
    [
        [0, 0, 0, 0, 0, 0],
        [500, 500, 500, 500, 500, 500],
        [1000, 1000, 1000, 1000, 1000, 1000],
        [1500, 1500, 1500, 1500, 1500, 1500],
        [2000, 2000, 2000, 2000, 2000, 2000],
        [2500, 2500, 2500, 2500, 2500, 2500],
    ]
)

# Vegetation cover (%) values, simulated with plausible trends
vegetation_cover = np.array(
    [
        [70, 65, 60, 55, 50, 45],
        [75, 70, 65, 60, 55, 50],
        [80, 75, 70, 65, 60, 55],
        [85, 80, 75, 70, 65, 60],
        [90, 85, 80, 75, 70, 65],
        [95, 90, 85, 80, 75, 70],
    ]
)

xlabel = "Temperature (°C)"
ylabel = "Elevation (m)"
zlabel = "Vegetation Cover (%)"
title = "Vegetation Cover Variation\nwith Elevation and Temperature"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig = plt.figure(
    figsize=(10, 6)
)
ax = fig.add_subplot(111, projection="3d")

# Plot a 3D surface
surf = ax.plot_surface(temperature, elevation, vegetation_cover, cmap="viridis", edgecolor="black")

# Labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title, y=1.00)
ax.set_box_aspect(aspect=(2, 1, 1))  # Aspect ratio for better visualization

# Add a color bar to show color scale
cbar = fig.colorbar(surf, ax=ax, shrink=0.5, aspect=5)
cbar.set_label(zlabel)

# ===================
# Part 4: Saving Output
# ===================
# Saving the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_29.pdf", bbox_inches="tight")
