
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define a new dataset representing business profit trends
m = np.linspace(0, 4, 200)  # Quarters
n = np.linspace(1, 100, 200)  # Time units
m, n = np.meshgrid(m, n)

z1 = 50 + 10 * n  # Steady growth
z2 = 50 + 10 * np.sin(n / 10) * n  # Cyclical fluctuations
z3 = 50 * np.exp(m / 5)  # Exponential growth
z4 = 50 * np.log(n + 1)  # Logarithmic growth

titles = ["Steady Growth", "Cyclical Fluctuations", "Exponential Growth", "Logarithmic Growth"]
xlabels = ["Quarter", "Quarter", "Quarter", "Quarter"]
ylabels = ["Time", "Time", "Time", "Time"]
zlabels = ["Profit ($)", "Profit ($)", "Profit ($)", "Profit ($)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specified size to match the original image's dimensions
fig = plt.figure(figsize=(15, 10))

# Plot the first subplot
ax1 = fig.add_subplot(
    141, projection="3d", facecolor="white"
)
surf1 = ax1.plot_surface(m, n, z1, cmap="plasma")
ax1.set_title(titles[0], fontsize=12, y=-0.1)
ax1.set_xlabel(xlabels[0], fontsize=12)
ax1.set_ylabel(ylabels[0], fontsize=12)
ax1.set_zlabel(zlabels[0], fontsize=12)

# Plot the second subplot
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
surf2 = ax2.plot_surface(m, n, z2, cmap="plasma")
ax2.set_title(titles[1], fontsize=14, y=-0.1)
ax2.set_xlabel(xlabels[1], fontsize=12)
ax2.set_ylabel(ylabels[1], fontsize=12)
ax2.set_zlabel(zlabels[1], fontsize=12, y=-0.3, rotation=0)

# Plot the third subplot
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
surf3 = ax3.plot_surface(m, n, z3, cmap="plasma")
ax3.set_title(titles[2], fontsize=14, y=-0.1)
ax3.set_xlabel(xlabels[2], fontsize=12)
ax3.set_ylabel(ylabels[2], fontsize=12)
ax3.set_zlabel(zlabels[3], fontsize=12, rotation=90)

# Plot the fourth subplot
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
surf4 = ax4.plot_surface(m, n, z4, cmap="plasma")
ax4.set_title(titles[3], fontsize=14, y=-0.1)
ax4.set_xlabel(xlabels[3], fontsize=12)
ax4.set_ylabel(ylabels[3], fontsize=12)
ax4.set_zlabel(zlabels[3], fontsize=12, rotation=90, x=-100)

# Zoom all the subplots
ax1.set_box_aspect(aspect=None)
ax2.set_box_aspect(aspect=None)
ax3.set_box_aspect(aspect=None)
ax4.set_box_aspect(aspect=None)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and spacing
plt.tight_layout()

# Show the plot
plt.savefig("3d_30.pdf", bbox_inches="tight")
