
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new financial data
time = np.linspace(0, 10, 200)  # Simulate time in years
stock_a = np.cumsum(np.random.randn(200))  # Simulate stock price A
stock_b = np.cumsum(np.random.randn(200) * 0.8)  # Simulate stock price B
interest_rate = np.sin(time) + np.random.randn(200) * 0.1  # Simulate interest rates
market_index = np.cumsum(np.random.randn(200) * 0.5)  # Simulate market index

# Titles and labels for the new context
titles = ["Stock A Price", "Stock B Price", "Interest Rate", "Market Index"]
xlabels = ["Time (years)", "Time (years)", "Time (years)", "Time (years)"]
ylabels = ["Price", "Price", "Rate", "Index"]
zlabels = ["Value", "Value", "Value", "Value"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specified size to match the original image's dimensions
fig = plt.figure(figsize=(15, 10))

# Plot the first subplot - Stock A Price
ax1 = fig.add_subplot(141, projection="3d", facecolor="white")
z1 = np.tile(stock_a, (200, 1))  # Create a surface by repeating the stock prices
m, n = np.meshgrid(time, time)
surf1 = ax1.plot_surface(m, n, z1, cmap="coolwarm")
ax1.set_title(titles[0], fontsize=14, y=1.05)
ax1.set_xlabel(xlabels[0], fontsize=12)
ax1.set_ylabel(ylabels[0], fontsize=12)
ax1.set_zlabel(zlabels[0], fontsize=12)

# Plot the second subplot - Stock B Price
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
z2 = np.tile(stock_b, (200, 1))
surf2 = ax2.plot_surface(m, n, z2, cmap="coolwarm")
ax2.set_title(titles[1], fontsize=14, y=1.05)
ax2.set_xlabel(xlabels[1], fontsize=12)
ax2.set_ylabel(ylabels[1], fontsize=12)
ax2.set_zlabel(zlabels[1], fontsize=12)

# Plot the third subplot - Interest Rate
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
z3 = np.tile(interest_rate, (200, 1))
surf3 = ax3.plot_surface(m, n, z3, cmap="coolwarm")
ax3.set_title(titles[2], fontsize=14, y=1.05)
ax3.set_xlabel(xlabels[2], fontsize=12)
ax3.set_ylabel(ylabels[2], fontsize=12)
ax3.set_zlabel(zlabels[2], fontsize=12)

# Plot the fourth subplot - Market Index
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
z4 = np.tile(market_index, (200, 1))
surf4 = ax4.plot_surface(m, n, z4, cmap="coolwarm")
ax4.set_title(titles[3], fontsize=14, y=1.05)
ax4.set_xlabel(xlabels[3], fontsize=12)
ax4.set_ylabel(ylabels[3], fontsize=12)
ax4.set_zlabel(zlabels[3], fontsize=12)

# Adjust layout and spacing
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.savefig("3d_31.pdf", bbox_inches="tight")
