
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate a new data representing 3D model vertices distribution
np.random.seed(42)
xp = np.linspace(0, 1, 17)
yp = np.random.normal(loc=0.5, scale=0.15, size=17)
zp = np.random.normal(loc=0.75, scale=0.2, size=17)

# Text labels and settings
xlabel = "X Axis"
ylabel = "Y Axis"
zlabel = "Z Axis"
chart_title = "3D Model Vertices Distribution"
legend_label = "Vertices"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(7, 7), subplot_kw={"projection": "3d"})

radius = 1
ax.set_xlim3d([0, radius])
ax.set_ylim3d([0, radius])
ax.set_zlim3d([0, radius * 1.5])
ax.view_init(elev=20.0, azim=60)
ax.dist = 8

# 3D scatter with optimized color scheme and styles
ax.scatter3D(xp, yp, zp, color="mediumseagreen", marker="o", s=50, label=legend_label)

# Draw connections with updated styles
# left leg
ax.plot(xp[0:4], yp[0:4], zp[0:4], ls="--", color="slateblue", lw=1.5)
# right leg
ax.plot(
    np.hstack((xp[0], xp[4:7])),
    np.hstack((yp[0], yp[4:7])),
    np.hstack((zp[0], zp[4:7])),
    ls="--", color="slateblue", lw=1.5
)
# spine
ax.plot(
    np.hstack((xp[0], xp[7:11])),
    np.hstack((yp[0], yp[7:11])),
    np.hstack((zp[0], zp[7:11])),
    ls="--", color="slateblue", lw=1.5
)
# right arm
ax.plot(
    np.hstack((xp[8], xp[11:14])),
    np.hstack((yp[8], yp[11:14])),
    np.hstack((zp[8], zp[11:14])),
    ls="--", color="slateblue", lw=1.5
)
# left arm
ax.plot(
    np.hstack((xp[8], xp[14:])),
    np.hstack((yp[8], yp[14:])),
    np.hstack((zp[8], zp[14:])),
    ls="--", color="slateblue", lw=1.5
)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(chart_title, pad=20)

plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_35.pdf", bbox_inches="tight")
