
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm

# ===================
# Part 2: Data Preparation
# ===================
# Generating data for oceanography domain.
import numpy as np

np.random.seed(0)
lat = np.arange(-90, 90, 2.5)
lon = np.arange(0, 360, 2.5)
lon, lat = np.meshgrid(lon, lat)
sst = np.sin(np.deg2rad(lat)) * np.cos(np.deg2rad(lon)) * 20

# Axes Limits and Labels
xlabel_value = "Longitude"
ylabel_value = "Latitude"
zlabel_value = "Sea Surface Temperature (°C)"
title_value = "Simulated Sea Surface Temperature"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6), subplot_kw={"projection": "3d"})

zlim_values = [-25, 25]

# Plot the surface.
surf = ax.plot_surface(lon, lat, sst, cmap=cm.Spectral, edgecolor='none')

# Customize the z axis.
ax.set_zlim(zlim_values)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_zlabel(zlabel_value)
ax.set_title(title_value)

# Add a color bar which maps values to colors.
fig.colorbar(surf, shrink=0.5, aspect=10, label='Temperature (°C)')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_37.pdf", bbox_inches="tight")
