
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Transportation data
cars = np.array(
    [
        [100, 120, 130, 110, 115, 140, 105, 125, 135, 145],
        [4, 5, 4, 4, 5, 4, 5, 5, 4, 4],
        [7, 6.5, 7.2, 6.8, 7.1, 6.7, 7.3, 6.6, 7.2, 6.9],
    ]
)
trains = np.array(
    [
        [80, 85, 90, 88, 82, 87, 84, 89, 90, 83],
        [300, 350, 400, 320, 330, 370, 360, 340, 365, 310],
        [5, 4.8, 5.2, 4.9, 5.1, 4.7, 5.3, 4.6, 5.0, 4.9],
    ]
)
airplanes = np.array(
    [
        [900, 910, 920, 905, 915, 930, 890, 925, 935, 940],
        [150, 155, 160, 140, 145, 150, 165, 170, 155, 160],
        [3, 2.9, 3.1, 3.0, 3.2, 2.8, 3.3, 2.7, 3.2, 3.0],
    ]
)

xlabel = "Speed (km/h)"
ylabel = "Capacity (passengers)"
zlabel = "Fuel Efficiency (liters/100km)"
title = "Comparison of Transportation Modes"
legendlabels = ["Cars", "Trains", "Airplanes"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

ax.scatter(cars[0], cars[1], cars[2], marker="o", color="teal", s=50, label=legendlabels[0], depthshade=False)
ax.scatter(trains[0], trains[1], trains[2], marker="^", color="magenta", s=50, label=legendlabels[1], depthshade=False)
ax.scatter(airplanes[0], airplanes[1], airplanes[2], marker="s", color="darkorange", s=50, label=legendlabels[2], depthshade=False)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)
ax.legend()

ax.set_xticks([100, 200, 300, 400, 500, 600, 700, 800, 900])
ax.set_yticks([100, 200, 300, 400, 500])
ax.set_zticks([2, 4, 6, 8])

ax.set_box_aspect(aspect=None, zoom=0.9)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_44.pdf", bbox_inches="tight")
