
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define new sales data for different products across regions
sales_data = np.array([[10, 15, 20, 25], [15, 20, 25, 30], [20, 25, 30, 35], [25, 30, 35, 40]])

# Define the edges of the bins
xedges = np.array([0, 1, 2, 3, 4])
yedges = np.array([0, 1, 2, 3, 4])

# Construct arrays for the anchor positions of the 4 bars.
xpos, ypos = np.meshgrid(xedges[:-1] + 0.25, yedges[:-1] + 0.25, indexing="ij")
xpos = xpos.ravel()
ypos = ypos.ravel()
zpos = 0

# Flatten the sales data and filter non-zero bars
dz = sales_data.ravel()
non_zero_indices = dz > 0
xpos = xpos[non_zero_indices]
ypos = ypos[non_zero_indices]
dz = dz[non_zero_indices]

# All bars have the same width and depth
dx = dy = 0.5 * np.ones_like(dz)

# Axes Limits and Labels
ax_xlabel = "Products"
ax_ylabel = "Regions"
ax_zlabel = "Sales Volume"
chart_title = "Sales Performance across Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a new figure for the modified 3D bar plot
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

zticks_values = [0, 10, 20, 30, 40]

# Define a color palette for the bars
colors = plt.cm.viridis(dz / dz.max())

ax.bar3d(xpos, ypos, zpos, dx, dy, dz, zsort="average", color=colors)

# Set axis labels and title
ax.set_xlabel(ax_xlabel, labelpad=10)
ax.set_ylabel(ax_ylabel, labelpad=10)
ax.set_zlabel(ax_zlabel, labelpad=10)
ax.set_title(chart_title, pad=20)

# Set z-axis ticks
ax.set_zticks(zticks_values)

ax.set_box_aspect(aspect=None, zoom=0.8)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_49.pdf", bbox_inches="tight")
