
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Parameters for labels and title
xlabel = "X-axis"
ylabel = "Y-axis"
zlabel = "Z-axis"
title = "3D Ellipsoid Surface Plot"
legendlabel = "Ellipsoid"

# Generate new data for a 3D ellipsoid
np.random.seed(0)
u = np.linspace(0, 2 * np.pi, 100)
v = np.linspace(0, np.pi, 100)
a, b, c = 6, 4, 8  # Ellipsoid radii
x = a * np.outer(np.cos(u), np.sin(v))
y = b * np.outer(np.sin(u), np.sin(v))
z = c * np.outer(np.ones(np.size(u)), np.cos(v))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

# Plot the surface with a gradient color map and edge colors
surf = ax.plot_surface(x, y, z, rstride=5, cstride=5, facecolors=plt.cm.viridis(z), edgecolor='none', alpha=0.9)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

# Adding a legend (not typical for 3D plots, using custom label for the surface)
from matplotlib.patches import Patch
legend_elements = [Patch(facecolor=plt.cm.viridis(0.5), edgecolor='none', label=legendlabel)]
ax.legend(handles=legend_elements, loc='upper left')

# Set an equal aspect ratio
ax.set_box_aspect([a, b, c])  # Aspect ratio is set to match the ellipsoid's shape

# Customize ticks
ax.set_xticks(np.arange(int(x.min()) - 1, int(x.max()) + 2, 4))
ax.set_yticks(np.arange(int(y.min()) - 1, int(y.max()) + 2, 4))
ax.set_zticks(np.arange(int(z.min()) - 1, int(z.max()) + 2, 4))

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_51.pdf", bbox_inches="tight")
