
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Define text label parameters
xlabel = 'X Axis'
ylabel = 'Y Axis'
zlabel = 'Z Axis'
title = '3D Surface Plot of a Torus'

# Generate data for a torus
R = 5
r = 2
u = np.linspace(0, 2 * np.pi, 100)
v = np.linspace(0, 2 * np.pi, 100)
u, v = np.meshgrid(u, v)
x = (R + r * np.cos(v)) * np.cos(u)
y = (R + r * np.cos(v)) * np.sin(u)
z = r * np.sin(v)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

# Plot the surface
ax.plot_surface(x, y, z, cmap="plasma", edgecolor="k", alpha=0.7)

# Set an equal aspect ratio
ax.set_aspect("auto")

# Setting labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_53.pdf", bbox_inches="tight")
