
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
yticklabels = ["Private Hospitals", "Public Hospitals"]
years = np.array([2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019])
private = np.array([50, 55, 60, 53, 61, 59, 65, 70, 68, 72])
public = np.array([75, 78, 80, 83, 82, 84, 87, 90, 88, 92])
xlabel = "Year"
ylabel = "Hospital Type"
zlabel = "Number of Patients"
title = "Number of Patients Admitted in Hospitals Over the Years (2010-2019)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

ax.bar(years, private, zs=0, zdir="y", color="lightcoral", alpha=0.85, edgecolor='darkred')
ax.bar(years, public, zs=1, zdir="y", color="lightseagreen", alpha=0.85, edgecolor='darkgreen')

ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)

ax.set_yticks([0, 1])
ax.set_yticklabels(yticklabels)

plt.title(title, pad=20, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_57.pdf", bbox_inches="tight")
