
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate data for different types of crop yields (wheat, rice, corn)
np.random.seed(42)

# Wheat yield data
wheat_yield = np.random.normal(
    loc=3000, scale=500, size=50
)  # mean yield around 3000 kg/ha

# Rice yield data
rice_yield = np.random.uniform(
    low=4000, high=6000, size=50
)  # randomly between 4000 and 6000 kg/ha

# Corn yield data
corn_yield = np.random.normal(
    loc=5000, scale=600, size=50
)  # mean yield around 5000 kg/ha

# Second set of data for variations in different conditions
wheat_yield2 = np.random.normal(loc=3200, scale=450, size=50)
rice_yield2 = np.random.uniform(low=4200, high=5800, size=50)
corn_yield2 = np.random.normal(loc=4800, scale=700, size=50)

labels = ["Yield Set 1", "Yield Set 2"]
xlabel = "Wheat Yield (kg/ha)"
ylabel = "Rice Yield (kg/ha)"
zlabel = "Corn Yield (kg/ha)"
title = "3D Crop Yield Patterns"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7), subplot_kw={"projection": "3d"})

# Configure the plot limits
ax.set_xlim3d([2000, 4000])
ax.set_ylim3d([3000, 6500])
ax.set_zlim3d([3500, 6500])

# Set the viewing angle
ax.view_init(elev=25, azim=60)
ax.dist = 10

# Scatter plot for the first set of data
ax.scatter3D(wheat_yield, rice_yield, corn_yield, color="#1f78b4", marker="o", label=labels[0])

# Scatter plot for the second set of data
ax.scatter3D(wheat_yield2, rice_yield2, corn_yield2, color="#33a02c", marker="^", label=labels[1])

# Modify axis labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=15)

ax.set_box_aspect(aspect=[1, 1, 1], zoom=0.95)

# Legend for the plot
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_67.pdf", bbox_inches="tight")
