
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Define the data for the sports metrics surface plots
x = np.linspace(-50, 50, 200)  
y = np.linspace(-50, 50, 200)  
x, y = np.meshgrid(x, y)

# Example sports metrics
z1 = 0.02 * np.sqrt(x**2 + y**2)  # Training Efficiency - radial distance
z2 = np.sin(0.1 * x) * np.cos(0.1 * y)  # Game Performance - oscillating pattern
z3 = np.exp(-0.02 * (x**2 + y**2))  # Injury Risk - decaying Gaussian
z4 = np.log1p(np.sqrt(x**2 + y**2))  # Overall Fitness - logarithmic growth

# Text variables for sports domain
title_training_efficiency = "Training Efficiency"
title_game_performance = "Game Performance"
title_injury_risk = "Injury Risk"
title_overall_fitness = "Overall Fitness"
x_label = "X Axis"
y_label = "Y Axis"
z_label_training = "Efficiency Value"
z_label_performance = "Performance Value"
z_label_injury = "Risk Value"
z_label_fitness = "Fitness Value"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
font_size = 12
title_pad = 10

# Create a figure with specified size
fig = plt.figure(figsize=(14, 10))

# Plot the first subplot - Training Efficiency
ax1 = fig.add_subplot(141, projection="3d", facecolor="white")
surf1 = ax1.plot_surface(x, y, z1, cmap="viridis", edgecolor='none')
ax1.set_title(title_training_efficiency, fontsize=font_size, pad=title_pad)
ax1.set_xlabel(x_label, fontsize=font_size)
ax1.set_ylabel(y_label, fontsize=font_size)
ax1.set_zlabel(z_label_training, fontsize=font_size)

# Plot the second subplot - Game Performance
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
surf2 = ax2.plot_surface(x, y, z2, cmap="plasma", edgecolor='none')
ax2.set_title(title_game_performance, fontsize=font_size, pad=title_pad)
ax2.set_xlabel(x_label, fontsize=font_size)
ax2.set_ylabel(y_label, fontsize=font_size)
ax2.set_zlabel(z_label_performance, fontsize=font_size)

# Plot the third subplot - Injury Risk
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
surf3 = ax3.plot_surface(x, y, z3, cmap="inferno", edgecolor='none')
ax3.set_title(title_injury_risk, fontsize=font_size, pad=title_pad)
ax3.set_xlabel(x_label, fontsize=font_size)
ax3.set_ylabel(y_label, fontsize=font_size)
ax3.set_zlabel(z_label_injury, fontsize=font_size)

# Plot the fourth subplot - Overall Fitness
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
surf4 = ax4.plot_surface(x, y, z4, cmap="cividis", edgecolor='none')
ax4.set_title(title_overall_fitness, fontsize=font_size, pad=title_pad)
ax4.set_xlabel(x_label, fontsize=font_size)
ax4.set_ylabel(y_label, fontsize=font_size)
ax4.set_zlabel(z_label_fitness, fontsize=font_size)

# Ensure all subplots have a consistent view initialization
for ax in [ax1, ax2, ax3, ax4]:
    ax.view_init(30, 45)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and spacing
plt.tight_layout()

# Save the plot to a file
plt.savefig("3d_74.pdf", bbox_inches="tight")
