
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.collections import PolyCollection

# ===================
# Part 2: Data Preparation
# ===================
# Set a random seed for reproducibility
import numpy as np

np.random.seed(0)

# Function to create polygon under graph
def polygon_under_graph(x, y):
    return [(x[0], 0.0), *zip(x, y), (x[-1], 0.0)]

# Data for bar chart
years = [2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019]
primary = [2.1, 2.2, 2.4, 2.8, 3.1, 3.5, 3.8, 4.0, 4.2, 4.5]
secondary = [1.5, 1.7, 1.8, 2.0, 2.3, 2.7, 3.0, 3.5, 3.8, 4.0]
tertiary = [0.9, 1.0, 1.2, 1.5, 1.8, 2.1, 2.5, 2.7, 3.0, 3.5]

# Data for distribution graph
x = np.linspace(0.0, 10.0, 31)
tech_levels = range(1, 4)
exp = np.exp
verts = [polygon_under_graph(x, exp(-0.5 * (x - t) ** 2)) for t in tech_levels]  # Gaussian distributions

# Labels and Titles
xlabel_bar_chart = "Year"
ylabel_bar_chart = "Education Level"
zlabel_bar_chart = "Investment (Billion USD)"
yticks_bar_chart = [0, 1, 2]
yticklabels_bar_chart = ["Primary", "Secondary", "Tertiary"]
title_bar_chart = "Investment in Education Levels Over a Decade"

xlabel_dist_graph = "Time Since Introduction (Years)"
ylabel_dist_graph = "Technology Level"
zlabel_dist_graph = "Adoption Rate"
yticks_dist_graph = [1, 2, 3]
title_dist_graph = "Adoption Rate of Education Technologies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize figure and axes
facecolors = plt.get_cmap("cool")(np.linspace(0, 1, len(verts)))
fig = plt.figure(figsize=(15, 10))
ax1 = fig.add_subplot(121, projection="3d")  # 3D bar chart
ax2 = fig.add_subplot(122, projection="3d")  # 3D distribution graph

# Plot data for bar chart
ax1.bar(years, primary, zs=0, zdir="y", color="#3498db", alpha=0.8)
ax1.bar(years, secondary, zs=1, zdir="y", color="#2ecc71", alpha=0.8)
ax1.bar(years, tertiary, zs=2, zdir="y", color="#e74c3c", alpha=0.8)

# Set labels and ticks for bar chart
ax1.set_xlabel(xlabel_bar_chart)
ax1.set_ylabel(ylabel_bar_chart)
ax1.set_zlabel(zlabel_bar_chart)
ax1.set_yticks(yticks_bar_chart)
ax1.set_yticklabels(yticklabels_bar_chart)
ax1.set_title(title_bar_chart, pad=20)

# Add polygons to the distribution graph
poly = PolyCollection(verts, facecolors=facecolors, alpha=0.7)
ax2.add_collection3d(poly, zs=tech_levels, zdir="y")

# Set labels and limits for distribution graph
ax2.set_xlim((0, 10))
ax2.set_ylim((1, 4))
ax2.set_zlim((0, 1))
ax2.set_xlabel(xlabel_dist_graph)
ax2.set_ylabel(ylabel_dist_graph)
ax2.set_zlabel(zlabel_dist_graph)
ax2.set_yticks(yticks_dist_graph)
ax2.set_title(title_dist_graph, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
plt.savefig("3d_77.pdf", bbox_inches="tight")
