
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import norm

np.random.seed(0)

# Sample data for demonstration purposes
x1 = np.linspace(18, 30, 100)
y1 = norm.pdf(x1, 24, 3)
x2 = np.linspace(31, 50, 100)
y2 = norm.pdf(x2, 40, 4)
x3 = np.linspace(51, 80, 100)
y3 = norm.pdf(x3, 65, 5)
labels = ["Young Voters", "Middle-aged Voters", "Senior Voters"]
xlabel = "Age"
ylabel = "Probability Density"
annotation_texts = ["Broad Age Range", "Narrower Age Range"]
title = "Distribution of Voter Age Groups"
supertitle = "Political Data Analysis"
legendlabels = ["Young", "Middle-aged", "Senior"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Plot the distributions
ax.plot(x1, y1, color="teal", linestyle="--", linewidth=2, label=labels[0])
ax.plot(x2, y2, color="goldenrod", linestyle="-", linewidth=2, label=labels[1])
ax.plot(x3, y3, color="maroon", linestyle=":", linewidth=2, label=labels[2])

# Draw histograms for each distribution
ax.hist(np.random.normal(24, 3, 1000), bins=10, density=True, alpha=0.5, color="lightgreen")
ax.hist(np.random.normal(40, 4, 1000), bins=10, density=True, alpha=0.5, color="khaki")
ax.hist(np.random.normal(65, 5, 1000), bins=10, density=True, alpha=0.5, color="lightcoral")

# Add annotations
ax.annotate(
    annotation_texts[0],
    xy=(24, 0.10),
    xytext=(40, 0.15),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
    fontsize=12,
    ha="center"
)
ax.annotate(
    annotation_texts[1],
    xy=(40, 0.06),
    xytext=(65, 0.10),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
    fontsize=12,
    ha="center"
)

# Add text labels
ax.text(31, 0.12, "12 Years", fontsize=12, ha="center")
ax.text(40, 0.08, "19 Years", fontsize=12, ha="center")

# Set labels, title, and layout
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)
fig.suptitle(supertitle, fontsize=18, y=0.98)

# Set axis limits and ticks
ax.set_ylim(0.00, 0.18)
ax.set_yticks([0.00, 0.05, 0.10, 0.15])

# Add legend
ax.legend(title="Voter Groups", title_fontsize='13', fontsize='11', ncol=1, bbox_to_anchor=(1, 1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("CB_102.pdf", bbox_inches="tight")
