
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data
years = [
    "2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"
]
netflix = [70, 80, 90, 105, 120, 130, 150, 165]
hulu = [30, 40, 50, 60, 70, 90, 100, 110]
disney_plus = [0, 0, 0, 50, 60, 80, 100, 130]
amazon_prime = [45, 50, 55, 60, 70, 88, 95, 105]
growth = [0.10, 0.12, 0.15, 0.20, 0.25, 0.30, 0.35, 0.40]
labels = ["Netflix", "Hulu", "Disney+", "Amazon Prime"]
xlabel = "Year"
ylabel1 = "Subscribers (in millions)"
ylabel2 = "Growth %"
legend_title = "Streaming Services"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Bar plot
bar_width = 0.2
index = np.arange(len(years))
ax1.bar(index, netflix, bar_width, label=labels[0], color="#7fc97f")
ax1.bar(index + bar_width, hulu, bar_width, label=labels[1], color="#beaed4")
ax1.bar(index + 2 * bar_width, disney_plus, bar_width, label=labels[2], color="#fdc086")
ax1.bar(index + 3 * bar_width, amazon_prime, bar_width, label=labels[3], color="#ffff99")

# Line plot
ax2 = ax1.twinx()
ax2.plot(
    years,
    growth,
    color="#386cb0",
    marker="D",
    linestyle="--",
    linewidth=2,
    markersize=7,
)

# Annotate growth percentages
for i, gr in enumerate(growth):
    ax2.annotate(
        f"{gr*100:.0f}%",
        (index[i] + bar_width * 1.5, gr),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        color="#386cb0",
    )

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + bar_width * 1.5)
ax1.set_xticklabels(years)

# Add legend
ax1.legend(loc="upper left", ncol=1, bbox_to_anchor=(1.05, 1), title=legend_title)
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# set ax2.yticklabels to be percentage
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
# Save the plot as a PDF file
plt.savefig("CB_103.pdf", bbox_inches="tight")
