
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(0)

# Generating sample data representing tourism trends for three different destinations
visitors1 = np.random.normal(50000, 7000, 100)  # Destination A
visitors2 = np.random.normal(75000, 10000, 100)  # Destination B
visitors3 = np.random.normal(65000, 9000, 100)  # Destination C

# Creating KDE for each sample data set to estimate the density of data points
kde1 = gaussian_kde(visitors1)
kde2 = gaussian_kde(visitors2)
kde3 = gaussian_kde(visitors3)

visitor_range = np.linspace(20000, 100000, 50)  # Defining the visitor range for plotting
labels = ["Destination A", "Destination B", "Destination C"]
ax1_legend_title = "Destinations"
ax1_xlabel = "Density"
ax2_ylabel = "Number of Visitors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Setting up the figure and axes for a 1 x 2 layout
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# First subplot: Fill between plot along y-axis (KDE Plot)
ax1.fill_betweenx(visitor_range, kde1(visitor_range), color="#66c2a5", alpha=0.4)
ax1.fill_betweenx(visitor_range, kde2(visitor_range), color="#fc8d62", alpha=0.5)
ax1.fill_betweenx(visitor_range, kde3(visitor_range), color="#8da0cb", alpha=0.3)
ax1.plot(kde1(visitor_range), visitor_range, label=labels[0], color="#1b9e77", linestyle='--')
ax1.plot(kde2(visitor_range), visitor_range, label=labels[1], color="#d95f02", linestyle='-.')
ax1.plot(kde3(visitor_range), visitor_range, label=labels[2], color="#7570b3", linestyle=':')
ax1.legend(title=ax1_legend_title, loc="upper right")
ax1.set_xlabel(ax1_xlabel)
ax1.set_yticks([])  # Hiding y-axis ticks for clarity

# Second subplot: Box plot for the same datasets along y-axis
box = ax2.boxplot(
    [visitors1, visitors2, visitors3], vert=True, patch_artist=True, medianprops={"color": "black"}
)
colors = ["#66c2a5", "#fc8d62", "#8da0cb"]  # Color matching with KDE plot
for patch, color in zip(box["boxes"], colors):
    patch.set_facecolor(color)

ax2.set_ylabel(ax2_ylabel)
ax2.set_xticks([])  # Hiding x-axis ticks for clarity
ax2.set_ylim(20000, 100000)  # Setting limits for y-axis to align with the KDE plot

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_112.pdf", bbox_inches="tight")
