
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
from scipy.stats import gaussian_kde

# Generating sample data representing approval ratings for three presidents
approval_a = np.random.normal(45, 5, 100)  # President A
approval_b = np.random.normal(55, 7, 100)  # President B
approval_c = np.random.normal(60, 6, 100)  # President C

# Creating KDE for each sample data set to estimate the density of data points
kde_a = gaussian_kde(approval_a)
kde_b = gaussian_kde(approval_b)
kde_c = gaussian_kde(approval_c)

approval_range = np.linspace(30, 80, 50)  # Defining the range of approval ratings for plotting
labels = ["President A (1900)", "President B (1950)", "President C (2000)"]
ax1_legend_title = "Presidents"
ax1_xlabel = "Density"
ax2_ylabel = "Approval Rating (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Setting up the figure and axes for a 1 x 2 layout
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# First subplot: Fill between plot along y-axis (KDE Plot)
ax1.fill_betweenx(approval_range, kde_a(approval_range), color="#add8e6", alpha=0.4)
ax1.fill_betweenx(approval_range, kde_b(approval_range), color="#f08080", alpha=0.5)
ax1.fill_betweenx(approval_range, kde_c(approval_range), color="#dda0dd", alpha=0.3)
ax1.plot(kde_a(approval_range), approval_range, label=labels[0], color="#0000ff", linestyle='--', linewidth=2)
ax1.plot(kde_b(approval_range), approval_range, label=labels[1], color="#ff0000", linestyle='-.', linewidth=2)
ax1.plot(kde_c(approval_range), approval_range, label=labels[2], color="#800080", linestyle='-', linewidth=2)
ax1.legend(title=ax1_legend_title, loc="upper right")
ax1.set_xlabel(ax1_xlabel)
ax1.set_yticks([])  # Hiding y-axis ticks for clarity

# Second subplot: Box plot for the same datasets along y-axis
box = ax2.boxplot(
    [approval_a, approval_b, approval_c], vert=True, patch_artist=True, medianprops={"color": "black"}
)
colors = ["#add8e6", "#f08080", "#dda0dd"]  # Color matching with KDE plot
for patch, color in zip(box["boxes"], colors):
    patch.set_facecolor(color)

ax2.set_ylabel(ax2_ylabel)
ax2.set_xticks([])  # Hiding x-axis ticks for clarity
ax2.set_ylim(30, 80)  # Setting limits for y-axis to align with the KDE plot

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_113.pdf", bbox_inches="tight")
