
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Media types
media_types = [
    "Streaming Services",
    "Social Media",
    "Podcasts",
    "News Websites",
    "Online Video",
    "E-books",
    "Music Streaming",
    "Online Gaming",
    "Blogs",
    "Forums",
]

# Popularity metrics in 2013 (in millions of users)
popularity_2013 = [30, 40, 20, 50, 35, 15, 20, 25, 10, 5]
# Popularity metrics in 2022 (in millions of users)
popularity_2022 = [80, 150, 90, 70, 200, 50, 100, 120, 40, 20]

x_label = "Millions of Users"
y_label = "Media Type"
ax1_title = "Media Popularity in 2013"
ax2_title = "Media Popularity in 2022"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (1x2) and shared y-axis
fig, axes = plt.subplots(1, 2, figsize=(12, 7), sharey=True)

colors = ["#1f77b4", "#ff7f0e"]
markers = ["o", "D"]

# Plotting the bar graphs
for i, (popularity, color, marker) in enumerate(zip([popularity_2013, popularity_2022], colors, markers)):
    axes[i].barh(media_types, popularity, color=color, edgecolor="gray", alpha=0.7)
    axes[i].set_xlabel(x_label)
    # Adding line graph on the same axes
    axes[i].plot(popularity, media_types, marker=marker, linestyle="--", color="#2ca02c", linewidth=2)

# Adding data labels
for ax, popularity in zip(axes, [popularity_2013, popularity_2022]):
    for index, value in enumerate(popularity):
        ax.text(value + 1, index, f" {value}", va="center", fontsize=10)

# Set labels and titles
axes[0].set_title(ax1_title, fontsize=14)
axes[1].set_title(ax2_title, fontsize=14)
axes[0].set_ylabel(y_label, fontsize=12)

# Enhance overall visualization
plt.suptitle("Comparison of Media Popularity Over Time", fontsize=16)
plt.grid(True, which='major', linestyle='--', linewidth=0.5)
plt.tight_layout(rect=[0, 0, 1, 0.96])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping and overlap
plt.savefig("CB_115.pdf", bbox_inches="tight")
