
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Media fields
media_fields = [
    "Streaming",
    "Social Media",
    "Augmented Reality",
    "Podcasting",
    "Virtual Reality",
    "Digital Content",
    "E-Sports",
    "Interactive Media",
    "3D Media",
    "AI in Media",
]

# Patent filings in 2013
patents_2013 = [45, 120, 30, 22, 34, 55, 18, 27, 15, 10]
# Patent filings in 2022
patents_2022 = [210, 350, 150, 120, 160, 250, 100, 130, 70, 60]

x_label = "Number of Patents"
y_label = "Media Field"
ax1_title = "Patent Filings in Media - 2013"
ax2_title = "Patent Filings in Media - 2022"
plot_color_2013 = "lightblue"
plot_color_2022 = "lightcoral"
line_color = "#8a2be2"  # Purple
marker_shape = "s"  # Square markers

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (1x2) and shared y-axis
fig, axes = plt.subplots(1, 2, figsize=(12, 6), sharey=True)

# Plotting the bar graphs
for i, (patents, color, ax_title) in enumerate(zip([patents_2013, patents_2022], [plot_color_2013, plot_color_2022], [ax1_title, ax2_title])):
    axes[i].barh(media_fields, patents, color=color, edgecolor="gray")
    axes[i].set_xlabel(x_label)
    axes[i].set_title(ax_title)
    # Adding line graph on the same axes
    axes[i].plot(patents, media_fields, marker_shape + "-", color=line_color, markerfacecolor="black")

# Adding data labels
for ax, patents in zip(axes, [patents_2013, patents_2022]):
    for index, value in enumerate(patents):
        ax.text(value + 1, index, f" {value}", va="center")

# Set y-axis label for the first subplot
axes[0].set_ylabel(y_label)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping and overlap
plt.tight_layout()
plt.savefig("CB_117.pdf", bbox_inches="tight")
