
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample health data
quarters = ["Q1", "Q2", "Q3", "Q4"]
hospitalA = [150, 180, 210, 240]
hospitalB = [160, 190, 220, 250]
hospitalC = [170, 200, 230, 260]
hospitalD = [180, 210, 240, 270]
recovery_rate = [0.88, 0.85, 0.90, 0.92]

# Errors (e.g., standard deviation)
errorA = [10, 15, 12, 14]
errorB = [11, 16, 13, 15]
errorC = [12, 17, 14, 16]
errorD = [13, 18, 15, 17]
error_recovery = [0.02, 0.03, 0.02, 0.01]
labels = ["Hospital A", "Hospital B", "Hospital C", "Hospital D"]
xlabel = "Quarter"
ylabel1 = "Successful Surgeries (#)"
ylabel2 = "Recovery Rate (%)"
legend_title = "Hospitals"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(8, 6))

# Bar plot with error bars
bar_width = 0.2
index = np.arange(len(quarters))
ax1.bar(
    index,
    hospitalA,
    bar_width,
    label=labels[0],
    color="lightblue",
    yerr=errorA,
    capsize=5,
    ecolor="navy",
)
ax1.bar(
    index + bar_width,
    hospitalB,
    bar_width,
    label=labels[1],
    color="lightgreen",
    yerr=errorB,
    capsize=5,
    ecolor="darkgreen",
)
ax1.bar(
    index + 2 * bar_width,
    hospitalC,
    bar_width,
    label=labels[2],
    color="lavender",
    yerr=errorC,
    capsize=5,
    ecolor="purple",
)
ax1.bar(
    index + 3 * bar_width,
    hospitalD,
    bar_width,
    label=labels[3],
    color="peachpuff",
    yerr=errorD,
    capsize=5,
    ecolor="sienna",
)

# Line plot with error bars
ax2 = ax1.twinx()
ax2.errorbar(
    index + 1.5 * bar_width,
    recovery_rate,
    yerr=error_recovery,
    fmt="o-",
    color="coral",
    label="Recovery Rate",
    linewidth=2,
    markersize=5,
    capsize=5,
)

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + 1.5 * bar_width)
ax1.set_xticklabels(quarters)

# Add legends
ax1.legend(loc="lower center", ncol=4, bbox_to_anchor=(0.5, -0.25), title=legend_title)
ax2.legend(loc="upper left", ncol=1)

# Set ax2.yticklabels to be percentage
ax2.set_ylim(0, 1)
ax2.set_yticks(np.linspace(0, 1, 11))
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# Grid and layout adjustment
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_118.pdf", bbox_inches="tight")
