
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample health data
months = ["January", "February", "March", "April"]
indicatorA = [120, 130, 125, 135]  # Blood Pressure
indicatorB = [75, 80, 78, 82]      # Heart Rate
indicatorC = [180, 190, 185, 195]  # Cholesterol Levels
indicatorD = [90, 100, 95, 105]    # Blood Sugar Levels
improvement = [0.1, 0.15, 0.1, 0.05]  # Improvement in health scores

# Errors (e.g., standard deviation)
errorA = [5, 6, 5, 7]
errorB = [3, 4, 3, 4]
errorC = [10, 12, 11, 13]
errorD = [4, 5, 4, 5]
error_improvement = [0.02, 0.03, 0.02, 0.01]
labels = ["Blood Pressure", "Heart Rate", "Cholesterol", "Blood Sugar"]
xlabel = "Month"
ylabel1 = "Health Indicators (units)"
ylabel2 = "Improvement %"
legend_title = "Indicators"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(10, 7))

# Bar plot with error bars
bar_width = 0.2
index = np.arange(len(months))
ax1.bar(
    index,
    indicatorA,
    bar_width,
    label=labels[0],
    color="#a6b1e1",
    yerr=errorA,
    capsize=5,
    ecolor="gray",
)
ax1.bar(
    index + bar_width,
    indicatorB,
    bar_width,
    label=labels[1],
    color="#f76c6c",
    yerr=errorB,
    capsize=5,
    ecolor="gray",
)
ax1.bar(
    index + 2 * bar_width,
    indicatorC,
    bar_width,
    label=labels[2],
    color="#ffcb77",
    yerr=errorC,
    capsize=5,
    ecolor="gray",
)
ax1.bar(
    index + 3 * bar_width,
    indicatorD,
    bar_width,
    label=labels[3],
    color="#4ecdc4",
    yerr=errorD,
    capsize=5,
    ecolor="gray",
)

# Line plot with error bars
ax2 = ax1.twinx()
ax2.errorbar(
    index + 1.5 * bar_width,
    improvement,
    yerr=error_improvement,
    fmt="o-",
    color="#ff6b6b",
    label="Improvement",
    linewidth=2,
    markersize=5,
    capsize=5,
)

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + 1.5 * bar_width)
ax1.set_xticklabels(months)

# Add legends
ax1.legend(loc="upper left", ncol=1, title=legend_title)
ax2.legend(loc="upper right", ncol=1)

# Set ax2.yticklabels to be percentage
ax2.set_ylim(0, 0.2)
ax2.set_yticks(np.linspace(0, 0.2, 5))
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# Grid and layout adjustment
ax1.grid(axis="y", linestyle='--', alpha=0.7)
ax1.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_119.pdf", bbox_inches="tight")
