
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample geography data: Population growth in thousands
quarters = ["Q1", "Q2", "Q3", "Q4"]
CityA = [500, 550, 580, 600]
CityB = [480, 530, 560, 590]
CityC = [470, 520, 550, 580]
CityD = [460, 510, 540, 570]
growth = [0.05, 0.03, 0.04, 0.02]

# Errors (e.g., standard deviation)
errorA = [30, 25, 35, 20]
errorB = [28, 26, 34, 22]
errorC = [27, 24, 33, 21]
errorD = [25, 23, 30, 19]
error_growth = [0.005, 0.003, 0.004, 0.002]
labels = ["CityA", "CityB", "CityC", "CityD"]
xlabel = "Quarter"
ylabel1 = "Population (1000s)"
ylabel2 = "Growth %"
legend_title = "Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(8, 6))

# Bar plot with error bars
bar_width = 0.2
index = np.arange(len(quarters))
ax1.bar(
    index,
    CityA,
    bar_width,
    label=labels[0],
    color="forestgreen",
    yerr=errorA,
    capsize=5,
    ecolor="black",
)
ax1.bar(
    index + bar_width,
    CityB,
    bar_width,
    label=labels[1],
    color="skyblue",
    yerr=errorB,
    capsize=5,
    ecolor="black",
)
ax1.bar(
    index + 2 * bar_width,
    CityC,
    bar_width,
    label=labels[2],
    color="gold",
    yerr=errorC,
    capsize=5,
    ecolor="black",
)
ax1.bar(
    index + 3 * bar_width,
    CityD,
    bar_width,
    label=labels[3],
    color="coral",
    yerr=errorD,
    capsize=5,
    ecolor="black",
)

# Line plot with error bars
ax2 = ax1.twinx()
ax2.errorbar(
    index + 1.5 * bar_width,
    growth,
    yerr=error_growth,
    fmt="s--",
    color="darkblue",
    label="Growth",
    linewidth=2,
    markersize=5,
    capsize=5,
)

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + 1.5 * bar_width)
ax1.set_xticklabels(quarters)

# Add legends
ax1.legend(loc="lower center", ncol=4, bbox_to_anchor=(0.5, -0.25), title=legend_title)
ax2.legend(loc="upper left", ncol=1)

# Set ax2.yticklabels to be percentage
ax2.set_ylim(0, 0.1)
ax2.set_yticks(np.linspace(0, 0.1, 11))
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# Grid and layout adjustment
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_120.pdf", bbox_inches="tight")
