
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import norm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for two cities' temperatures
city_a_temp = np.random.normal(loc=15, scale=10, size=500)
city_b_temp = np.random.normal(loc=25, scale=5, size=500)

# Labels and Plot Types
ax1_label = "City A"
ax2_label = "City B"
ax1_text = "Mean Temp City A"
ax2_text = "Mean Temp City B"

# Axes Limits and Labels
xlabel_value = "Temperature (°C)"
ylabel_value = "Density"
xticks_values = [-10, 0, 10, 20, 30, 40, 50]
xlim_values = [-15, 55]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Plot histograms
ax.hist(city_a_temp, bins=15, density=True, alpha=0.7, color="#89CFF0", label=ax1_label)
ax.hist(city_b_temp, bins=15, density=True, alpha=0.7, color="#FF7F50", label=ax2_label)

# Plot normal distributions
xmin, xmax = ax.get_xlim()
x = np.linspace(xmin, xmax, 100)
p_a = norm.pdf(x, np.mean(city_a_temp), np.std(city_a_temp))
p_b = norm.pdf(x, np.mean(city_b_temp), np.std(city_b_temp))
ax.plot(x, p_a, color="#4682B4", linewidth=3)
ax.plot(x, p_b, color="#CD5C5C", linewidth=3)

# Add dashed lines at mean
ax.axvline(np.mean(city_a_temp), color="black", linestyle="dashed")
ax.axvline(np.mean(city_b_temp), color="black", linestyle="dashed")

# Add text labels for dashed lines
ax.text(np.mean(city_a_temp) + 1.5, ax.get_ylim()[1] - 0.01, ax1_text, ha="center", va="top", fontsize=18)
ax.text(np.mean(city_b_temp) + 1.5, ax.get_ylim()[1] - 0.005, ax2_text, ha="center", va="top", fontsize=18)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_xticks(xticks_values)
ax.set_xlim(xlim_values)

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("CB_33.pdf", bbox_inches="tight")
