
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
platforms = ["Netflix", "Amazon Prime", "Disney+", "Hulu", "HBO Max", "Apple TV+"]
movies = [70, 65, 50, 45, 60, 55]
tv_shows = [80, 70, 55, 60, 50, 40]
documentaries = [90, 60, 65, 55, 70, 50]
movie_trend = [70, 65, 50, 45, 60, 55]
labels = ["Movies", "TV Shows", "Documentaries", "Movie Trend"]

xlabel = "Streaming Platform"
ylabel = "User Engagement Rate (%)"
title = "User Engagement Across Streaming Platforms"
yticks = np.arange(0, 101, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size for better readability

bar_width = 0.25
index = np.arange(len(platforms))

bar1 = ax.bar(index, movies, bar_width, label=labels[0], color="#FF6F61", edgecolor="grey")
bar2 = ax.bar(index + bar_width, tv_shows, bar_width, label=labels[1], color="#6B5B95", edgecolor="grey")
bar3 = ax.bar(index + 2 * bar_width, documentaries, bar_width, label=labels[2], color="#88B04B", edgecolor="grey")

# Trend line for 'Movie Trend'
ax.plot(index, movie_trend, color="#FFA500", marker="s", linestyle="solid", linewidth=2, markersize=8, label=labels[3])

# Adding percentages on top of the bars
for rect in bar1 + bar2 + bar3:
    height = rect.get_height()
    ax.text(rect.get_x() + rect.get_width() / 2.0, height, f"{height}%", ha="center", va="bottom")

# Labels, title and custom x-axis tick labels
ax.set_xlabel(xlabel, fontsize=12, fontweight='bold')
ax.set_ylabel(ylabel, fontsize=12, fontweight='bold')
ax.set_yticks(yticks)
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xticks(index + bar_width)
ax.set_xticklabels(platforms, rotation=30)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_34.pdf", bbox_inches="tight")
