
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
cities = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix", "Philadelphia"]
summer = [29, 35, 30, 33, 41, 31]
winter = [-1, 15, -2, 12, 20, 2]
monsoon = [25, 30, 23, 27, 35, 28]
temperature_trend = [18, 27, 17, 24, 32, 20]
labels = ["Summer", "Winter", "Monsoon", "Temperature Trend"]

xlabel = "City"
ylabel = "Temperature (°C)"
title = "Seasonal Temperature Variations by City"
yticks = np.arange(-5, 46, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

bar_width = 0.25
index = np.arange(len(cities))

bar1 = ax.bar(index, summer, bar_width, label=labels[0], color="#ffcccb", edgecolor="grey")
bar2 = ax.bar(index + bar_width, winter, bar_width, label=labels[1], color="#add8e6", edgecolor="grey")
bar3 = ax.bar(index + 2 * bar_width, monsoon, bar_width, label=labels[2], color="#90ee90", edgecolor="grey")

# Trend line for 'Temperature Trend'
ax.plot(index, temperature_trend, color="#ffa500", marker="o", linestyle="dashed", label=labels[3], linewidth=2)

# Adding temperatures on top of the bars
for i, rect in enumerate(bar1 + bar2 + bar3):
    height = rect.get_height()
    ax.text(rect.get_x() + rect.get_width() / 2.0, height, f"{height}°C", ha="center", va="bottom")

# Labels, title and custom x-axis tick labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_yticks(yticks)
ax.set_title(title, fontsize=15)
ax.set_xticks(index + bar_width)
ax.set_xticklabels(cities, rotation=30)
ax.legend(fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_35.pdf", bbox_inches="tight")
