
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
startups = ["Startup A", "Startup B", "Startup C", "Startup D", "Startup E", "Startup F"]
market_penetration = [15, 25, 35, 45, 20, 30]
growth_potential = [20, 15, 50, 30, 25, 35]
innovation = [30, 40, 20, 50, 10, 25]
sustainability_trend = [10, 20, 30, 40, 50, 60]
labels = ["Market Penetration", "Growth Potential", "Innovation", "Sustainability Trend"]

xlabel = "Startup"
ylabel = "Success Rate (%)"
title = "Evaluation Metrics for Tech Startups"
yticks = np.arange(0, 61, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

bar_width = 0.25
index = np.arange(len(startups))

bar1 = ax.bar(index, market_penetration, bar_width, label=labels[0], color="#5DADE2", edgecolor="grey")
bar2 = ax.bar(index + bar_width, growth_potential, bar_width, label=labels[1], color="#52BE80", edgecolor="grey")
bar3 = ax.bar(index + 2 * bar_width, innovation, bar_width, label=labels[2], color="#F4D03F", edgecolor="grey")

# Trend line for 'Sustainability Trend'
ax.plot(index + bar_width, sustainability_trend, color="#EC7063", marker="D", linestyle="--", markersize=8, label=labels[3])

# Adding percentages on top of the bars
for rects in [bar1, bar2, bar3]:
    for rect in rects:
        height = rect.get_height()
        ax.text(rect.get_x() + rect.get_width() / 2.0, height, f"{height}%", ha="center", va="bottom")

# Labels, title and custom x-axis tick labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_yticks(yticks)
ax.set_title(title)
ax.set_xticks(index + 1.5 * bar_width)
ax.set_xticklabels(startups, rotation=45)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_36.pdf", bbox_inches="tight")
