
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
months = np.arange(1, 13)
before_campaign = [50, 52, 55, 60, 65, 62, 70, 75, 80, 83, 85, 90]
after_campaign = [55, 57, 60, 70, 78, 75, 85, 90, 95, 98, 100, 110]
percentages = [
    "10%", "9.6%", "9.1%", "16.7%", "20%", "21%", "21.4%", "20%", "18.8%", "18%", "17.6%", "22.2%"
]

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Tourist Arrivals (in thousands)"
xticklabels = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot data with different marker style
ax.plot(months, before_campaign, color="#ffa500", linestyle="--", linewidth=2, label='Before Campaign')
ax.plot(months, after_campaign, color="#1f77b4", linestyle="--", linewidth=2, label='After Campaign')
ax.scatter(months, before_campaign, marker="o", color="#ffa500", s=100)
ax.scatter(months, after_campaign, marker="^", color="#1f77b4", s=100)

# Annotate percentages with different font style
for i, txt in enumerate(percentages):
    ax.annotate(
        txt,
        (months[i], after_campaign[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=9,
        color='black'
    )

# Set labels with different font style
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)

# Set ticks
ax.set_xticks(months)
ax.set_yticks(range(50, 121, 10))

# Set tick labels with different font style
ax.set_xticklabels(xticklabels, fontsize=9)
ax.set_yticklabels(range(50, 121, 10), fontsize=9)

# Set grid with lighter lines
ax.grid(True, linestyle="--", linewidth=0.5, color="gray")

# Add title and legend
ax.set_title('Monthly Tourist Arrivals Before and After Campaign', fontsize=14)
ax.legend(loc='upper left', fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_49.pdf", bbox_inches="tight")
