
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Sample economic data
x = np.random.normal(2, 0.5, 1000)  # GDP growth rates
y = np.random.normal(3, 1, 1000)    # Inflation rates

xlabel = "GDP Growth Rate (%)"
ylabel = "Inflation Rate (%)"
title = "Economic Data: GDP Growth vs Inflation"
supertitle = "Economic Indicators Analysis"
legendlabels = ["GDP Growth", "Inflation"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and gridspec
fig = plt.figure(figsize=(10, 10))
gs = gridspec.GridSpec(2, 2, width_ratios=[5, 1], height_ratios=[1, 5])
fig.suptitle(supertitle, fontsize=16)

# Main hexbin plot
ax = plt.subplot(gs[1, 0])
hb = ax.hexbin(x, y, gridsize=30, cmap="YlGn", mincnt=1)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim(-1, 5)
ax.set_ylim(-1, 7)
ax.axhline(y.mean(), color="orange", linestyle="--", linewidth=1.5, label=f"Mean {ylabel}")
ax.axvline(x.mean(), color="green", linestyle="--", linewidth=1.5, label=f"Mean {xlabel}")
ax.legend()

# Histogram on the top
ax_histx = plt.subplot(gs[0, 0], sharex=ax)
ax_histx.hist(x, bins=30, color="skyblue", edgecolor="navy", linewidth=1.5)
ax_histx.axis("off")  # Hide axis

# Histogram on the right
ax_histy = plt.subplot(gs[1, 1], sharey=ax)
ax_histy.hist(
    y,
    bins=30,
    orientation="horizontal",
    color="lightcoral",
    edgecolor="darkred",
    linewidth=1.5,
)
ax_histy.axis("off")  # Hide axis

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("CB_52.pdf", bbox_inches="tight")
