
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)

# Sample data
region_scores = np.random.beta(a=2.0, b=5.0, size=1000)  # Political party scores
time_points = np.random.beta(a=2.0, b=5.0, size=1000)    # Popularity over time
xlabel = "Political Party Popularity Score"
ylabel = "Regions Influence Over Time"

# Text labels for the chart
title = "Political Party Popularity vs. Regional Influence"
supertitle = "Analysis of Popularity and Influence in Political Domain"
annotation_text = "Threshold"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and gridspec
fig = plt.figure(figsize=(10, 10))
gs = gridspec.GridSpec(2, 2, width_ratios=[5, 1], height_ratios=[1, 5])

# Main hexbin plot
ax = plt.subplot(gs[1, 0])
hb = ax.hexbin(region_scores, time_points, gridsize=30, cmap="RdBu", mincnt=1)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xlim(0, 1)
ax.set_ylim(0, 1)
ax.axhline(0.5, color="#990000", linestyle="--", linewidth=1.5)
ax.axvline(0.5, color="#003366", linestyle="--", linewidth=1.5)
ax.set_title(title, fontsize=14)

# Histogram on the top
ax_histx = plt.subplot(gs[0, 0], sharex=ax)
ax_histx.hist(region_scores, bins=30, color="#003366", edgecolor="white", linewidth=1.5)
ax_histx.axis("off")  # Hide axis

# Histogram on the right
ax_histy = plt.subplot(gs[1, 1], sharey=ax)
ax_histy.hist(time_points, bins=30, orientation="horizontal", color="#990000", edgecolor="white", linewidth=1.5)
ax_histy.axis("off")  # Hide axis

# Add a color bar for the hexbin plot
cb = fig.colorbar(hb, ax=ax, orientation='vertical')
cb.set_label('Counts')

# Add a supertitle for the figure
plt.suptitle(supertitle, fontsize=16, weight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("CB_53.pdf", bbox_inches="tight")
