
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for weather domain
temperature = np.random.normal(loc=20, scale=5, size=1000)  # Normally distributed temperatures
humidity = np.random.uniform(low=0, high=100, size=1000)   # Uniformly distributed humidity
xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"
title = "Temperature vs Humidity Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and gridspec
fig = plt.figure(figsize=(8, 8))
gs = gridspec.GridSpec(2, 2, width_ratios=[5, 1], height_ratios=[1, 5])

# Main hexbin plot
ax = plt.subplot(gs[1, 0])
hb = ax.hexbin(temperature, humidity, gridsize=30, cmap="YlGnBu", mincnt=1, edgecolors='grey')
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim(0, 40)
ax.set_ylim(0, 100)
ax.axhline(50, color="gray", linestyle="--", linewidth=1)
ax.axvline(20, color="gray", linestyle="--", linewidth=1)

# Color bar
cb = fig.colorbar(hb, ax=ax)
cb.set_label('Counts')

# Histogram on the top
ax_histx = plt.subplot(gs[0, 0], sharex=ax)
ax_histx.hist(temperature, bins=30, color="lightblue", edgecolor="darkblue", linewidth=1.2)
ax_histx.axis("off")  # Hide axis

# Histogram on the right
ax_histy = plt.subplot(gs[1, 1], sharey=ax)
ax_histy.hist(
    humidity,
    bins=25,
    orientation="horizontal",
    color="lightgreen",
    edgecolor="darkgreen",
    linewidth=1.2,
)
ax_histy.axis("off")  # Hide axis

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
plt.savefig("CB_54.pdf", bbox_inches="tight")
