
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
methods = ["Method A", "Method B", "Method C", "Method D"]
hi_values = [0.85, 0.88, 0.90, 0.87]
sri_values = [0.82, 0.85, 0.86, 0.84]
aggregate_values = [1.67, 1.73, 1.76, 1.71]
labels = ["Happiness Index (HI)", "Stress Reduction Index (SRI)", "Aggregate Index (HI + SRI)"]
xlabel = "Methods"
ylabel = "Index Values"
title = "Effectiveness of Different Methods on Mental Well-being"
legendlabels = ["Happiness Index (HI)", "Stress Reduction Index (SRI)", "Aggregate Index (HI + SRI)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar plot
fig, ax1 = plt.subplots(
    figsize=(10, 6)
)  # Adjust the figsize to match the original image's dimensions

bar_width = 0.35
index = np.arange(len(methods))

bar1 = ax1.bar(index, hi_values, bar_width, label=labels[0], color="#87CEEB")  # Pastel blue
bar2 = ax1.bar(
    index + bar_width, sri_values, bar_width, label=labels[1], color="#90EE90"  # Light green
)

# Line plot
ax2 = ax1.twinx()
(line,) = ax2.plot(index + bar_width / 2, aggregate_values, color="#FFA07A", marker="D", linestyle='-', label=labels[2])  # Light coral with diamond marker

# Annotate bars with values
for rect, value in zip(bar1, hi_values):
    height = rect.get_height()
    ax1.text(
        rect.get_x() + rect.get_width() / 2,
        height + 0.005,
        f"{value:.2f}",
        ha="center",
        va="bottom",
    )

for rect, value in zip(bar2, sri_values):
    height = rect.get_height()
    ax1.text(
        rect.get_x() + rect.get_width() / 2,
        height + 0.005,
        f"{value:.2f}",
        ha="center",
        va="bottom",
    )

# Labels, title and legend
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(title)
ax1.set_xticks(index + bar_width / 2)
ax1.set_xticklabels(methods)
ax1.set_ylim(0.80, 0.92)
ax1.set_yticks([0.80, 0.82, 0.84, 0.86, 0.88, 0.90])
ax2.set_ylim(1.65, 1.80)
ax2.set_yticks([1.65, 1.70, 1.75, 1.80])
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

ax1.yaxis.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(10, 6)

# Show plot
plt.tight_layout()
plt.savefig("CB_57.pdf", bbox_inches="tight")

