
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample (x, y) for the scatter plot representing air quality (x) and PM2.5 levels (y)
data = {
    "Good": [[np.random.randint(20, 50), np.random.rand() * 15 + 5] for _ in range(10)],
    "Moderate": [[np.random.randint(50, 100), np.random.rand() * 25 + 30] for _ in range(2)],
    "Poor": [[np.random.randint(100, 150), np.random.rand() * 35 + 60] for _ in range(10)],
}

line_x = np.array([20, 50, 80, 110, 140, 150])
line_y = np.array([10, 20, 30, 40, 50, 60])

labels = ["Good", "Moderate", "Poor"]
correlation = -0.52
xlabel = "Air Quality Index (AQI)"
ylabel = "PM2.5 Levels (µg/m³)"
legend_title = "Air Quality Levels"
correlation = f"Correlation: {correlation:.2f}"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

colors = ["#2ca02c", "#ff7f0e", "#d62728"]  # Use HEX color codes for domain-specific colors
# Create scatter plot
plt.figure(figsize=(10, 6))  # Adjust figure size to match original image dimensions

for key in data:
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[labels.index(key)], label=key, s=80, edgecolors='w', linewidths=0.5)

# Add regression line
plt.plot(line_x, line_y, color="gray", linestyle="--", linewidth=2)

# Add shaded area for standard deviation
std_dev = 5
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="gray", alpha=0.2)

# Add legend inside the plot area
plt.legend(title=legend_title, loc="upper left")

# Add correlation text with a box inside the plot area
plt.text(line_x[-2], line_y[-2] + 3, correlation, fontsize=10, bbox=dict(facecolor='white', alpha=0.6))

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title("Correlation between AQI and PM2.5 Levels")

plt.yticks(np.arange(line_y.min(), line_y.max() + 10, 10))

# Set grid
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_59.pdf", bbox_inches="tight")
