
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample (x,y) for the scatter plot
data = {
    "Inactive": [[np.random.randint(2000, 5000), np.random.rand() - 3] for _ in range(10)],
    "Moderately Active": [[np.random.randint(5000, 8000), np.random.rand() - 4] for _ in range(2)],
    "Active": [[np.random.randint(8000, 12000), np.random.rand() - 6] for _ in range(10)],
}

line_x = np.array([2000, 4000, 6000, 8000, 10000, 12000])
line_y = np.array([-1, -2, -3, -4, -5, -6])

labels = ["Inactive", "Moderately Active", "Active"]
correlation = -0.47
xlabel = "Average Daily Step Count"
ylabel = "BMI Change Rate"
legend_title = "Activity Level"
correlation = f"Correlation: {correlation:.2f}"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8BC34A", "#FFC107", "#FF5722"]  # Greens and warm colors

plt.figure(figsize=(9, 6))  # Adjust figure size

# Add scatter plot points
for key in data:
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[labels.index(key)], label=key, edgecolor='k', s=100, alpha=0.7)

# Add regression line
plt.plot(line_x, line_y, color="black", linestyle='--', linewidth=2)

# Add shaded area for standard deviation
std_dev = 0.5
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="gray", alpha=0.2)

# Add legend inside the plot area
plt.legend(title=legend_title, loc="upper right")

# Add correlation text with a box inside the plot area
plt.text(line_x[-2], line_y[-2], correlation, fontsize=12, bbox=dict(facecolor='white', alpha=0.5, edgecolor='none'))

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)

plt.yticks(np.arange(line_y.min(), line_y.max() + 2, 1))

# Set grid
plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_60.pdf", bbox_inches="tight")
