
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42) 

# Sample (x,y) for the scatter plot for the new dataset
data = {
    "High Nutrient": [[np.random.rand() * 2, np.random.rand() * 3] for _ in range(10)],
    "Medium Nutrient": [[np.random.rand() * 2 - 1, np.random.rand() * 2] for _ in range(10)],
    "Low Nutrient": [[np.random.rand() - 0.5, np.random.rand()] for _ in range(10)],
    "No Nutrient": [[np.random.rand() - 1.5, np.random.rand() - 1] for _ in range(10)],
}

line_x = np.array([-2, 2])
line_y = np.array([-1, 3])
labels = ["No Nutrient", "Low Nutrient", "Medium Nutrient", "High Nutrient"]
correlation = 0.65
xlabel = "Nutrient Concentration"
ylabel = "Plant Growth (cm)"
title = "Plant Growth under Different Nutrient Conditions"
correlation_text = f"Correlation: {correlation:.2f}"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#2e8b57",  # Sea Green
    "#66cdaa",  # Medium Aquamarine
    "#3cb371",  # Medium Sea Green
    "#8fbc8f",  # Dark Sea Green
]

# Create scatter plot
plt.figure(figsize=(8, 6))  # Adjust figure size

for key in data:
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[labels.index(key)], label=key, alpha=0.7, edgecolors='w', s=100)

# Add regression line
plt.plot(line_x, line_y, color="darkgreen", linestyle='--', linewidth=2)

# Add shaded area for standard deviation
std_dev = 0.5
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="green", alpha=0.2)

# Add legend inside the plot area
plt.legend(loc="upper left", title="Nutrient Levels")

# Add correlation text with a box inside the plot area
plt.text(line_x.mean(), line_y.mean(), correlation_text, fontsize=10, bbox=dict(facecolor='white', edgecolor='black'))

# Set labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=15)

# Set grid
plt.grid(True, linestyle='--', linewidth=0.7, alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_61.pdf", bbox_inches="tight")
