
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample (x, y) for the scatter plot representing Population Growth vs. Resource Availability
data = {
    "Very Low": [[np.random.rand() * 0.5 - 3, np.random.rand() * 0.5 - 3] for _ in range(10)],
    "Low": [[np.random.rand() * 0.5 - 2, np.random.rand() * 0.5 - 2] for _ in range(10)],
    "Medium": [[np.random.rand() * 0.5 - 1, np.random.rand() * 0.5 - 1] for _ in range(10)],
    "High": [[np.random.rand() * 0.5, np.random.rand() * 0.5] for _ in range(10)],
}

line_x = np.array([-3.5, 0.5])
line_y = np.array([-3.5, 0.5])
labels = ["Very Low", "Low", "Medium", "High"]
correlation = -0.52
xlabel = "Log (Resource Availability)"
ylabel = "Log (Population Growth)"
correlation_text = f"Correlation: {correlation:.2f}"
title = "Population Growth vs. Resource Availability"
supertitle = "Scatter Plot with Regression Line"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#1f77b4",  # Blue
    "#ff7f0e",  # Orange
    "#2ca02c",  # Green
    "#d62728",  # Red
]
markers = ['o', 's', 'D', '^']  # Circle, Square, Diamond, Triangle Up

# Create scatter plot
plt.figure(figsize=(9, 6))  # Adjust figure size

for idx, key in enumerate(data):
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[idx], label=key, marker=markers[idx])

# Add regression line
plt.plot(line_x, line_y, color="black", linestyle='--', linewidth=1.5)

# Add shaded area for standard deviation
std_dev = 0.3
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="black", alpha=0.1)

# Add legend inside the plot area
plt.legend(loc="upper left")

# Add correlation text with a box inside the plot area
plt.text(line_x.mean(), line_y.mean(), correlation_text, fontsize=10, bbox=dict(facecolor='white', alpha=0.7))

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.suptitle(supertitle)

# Set grid
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_62.pdf", bbox_inches="tight")

