
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for demonstration purposes
dataset1 = np.random.normal(loc=0, scale=1, size=1000)
dataset2 = np.random.uniform(low=-2, high=2, size=1000)

# Compute KDE for both datasets
kde_dataset1 = gaussian_kde(dataset1)
kde_dataset2 = gaussian_kde(dataset2)

# Create an array of values for plotting KDE
x_eval = np.linspace(
    min(np.concatenate([dataset1, dataset2])),
    max(np.concatenate([dataset1, dataset2])),
    1000,
)

labels = ["Normal Distribution", "Uniform Distribution", "Normal KDE", "Uniform KDE"]
p_text = "T-test p-value = 0.0413"
x_label = "Value"
y_label = "Density"
title = "Comparison of Normal and Uniform Distributions"
suptitle = "Data Visualization using KDE and Histogram"
legend_labels = ["Dataset 1", "Dataset 2"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(10, 6))

# Plot histograms
plt.hist(
    dataset2, density=True, bins=30, color="#87CEEB", alpha=0.7, label=legend_labels[0]
)
plt.hist(
    dataset1, density=True, bins=30, color="#FFB6C1", alpha=0.7, label=legend_labels[1]
)

# Plot KDEs
plt.plot(
    x_eval,
    kde_dataset2(x_eval),
    linestyle="dotted",
    color="blue",
    label=labels[2],
    linewidth=2
)
plt.plot(
    x_eval,
    kde_dataset1(x_eval),
    linestyle="dotted",
    color="red",
    label=labels[3],
    linewidth=2
)

# Add legend
plt.legend()

# Add T-test p-value text
plt.text(0.0, 0.4, p_text, fontsize=10, bbox=dict(facecolor='white', alpha=0.5))

# Set labels and title
plt.xlabel(x_label)
plt.ylabel(y_label)
plt.title(title)
plt.suptitle(suptitle, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_66.pdf", bbox_inches="tight")
