
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for societal income distribution
income_group_A = np.random.normal(50000, 12000, 1000)
income_group_B = np.random.normal(60000, 15000, 1000)

min_bin = min(min(income_group_A), min(income_group_B))
max_bin = max(max(income_group_A), max(income_group_B))

bins = np.linspace(min_bin, max_bin, 30)
bin_width = bins[1] - bins[0]
labels = ["Group A - Income", "Group B - Income"]
legend_title = "Income Groups"
title = "Income Distribution of Two Social Groups"
xlabel = "Income"
ylabel = "Count"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
figure = plt.figure(figsize=(10, 6))

# Create histogram
count_A, bins_A, _ = plt.hist(
    income_group_A,
    bins=bins,
    color="#8bc34a",
    alpha=0.7,
    label=labels[0],
    edgecolor="black",
    linewidth=1.25,
)
count_B, bins_B, _ = plt.hist(
    income_group_B,
    bins=bins,
    alpha=0.7,
    color="#ff9800",
    label=labels[1],
    edgecolor="black",
    linewidth=1.25,
)

# Create line plot on top of the histogram with different styles
plt.plot(bins_A[:-1] + bin_width * 0.5, count_A, color="#388e3c", linewidth=1.5, linestyle='-')
plt.plot(bins_B[:-1] + bin_width * 0.5, count_B, color="#f57c00", linewidth=1.5, linestyle='--')

# Add grid for better readability
plt.grid(True, linestyle='--', alpha=0.5)

# Add legend, title, and labels
plt.legend(loc="upper right", title=legend_title)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_70.pdf", bbox_inches="tight")
