
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data representing income distributions in Urban and Rural regions
income_urban = np.random.normal(70000, 15000, 1000)
income_rural = np.random.normal(45000, 10000, 1000)

min_bin = min(min(income_urban), min(income_rural))
max_bin = max(max(income_urban), max(income_rural))

bins = np.linspace(min_bin, max_bin, 30)
bin_width = bins[1] - bins[0]
labels = ["Urban Region", "Rural Region"]
legend_title = "Region"
title = "Income Distribution Comparison"
xlabel = "Income ($)"
ylabel = "Frequency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
figure = plt.figure(figsize=(10, 6))

# Create histogram
count_urban, bins_urban, _ = plt.hist(
    income_urban,
    bins=bins,
    color="#78c679",
    alpha=0.7,
    label=labels[0],
    edgecolor="#238443",
    linewidth=1.25,
)
count_rural, bins_rural, _ = plt.hist(
    income_rural,
    bins=bins,
    alpha=0.7,
    color="#41b6c4",
    label=labels[1],
    edgecolor="#225ea8",
    linewidth=1.25,
)

# Create line plot on top of the histogram and set edge color
plt.plot(bins_urban[:-1] + bin_width * 0.5, count_urban, color="#005a32", linewidth=1.5, linestyle='--')
plt.plot(bins_rural[:-1] + bin_width * 0.5, count_rural, color="#045a8d", linewidth=1.5, linestyle='--')

# Add legend, title, and labels
plt.legend(loc="upper right", title=legend_title)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Add gridlines for better readability
plt.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_72.pdf", bbox_inches="tight")
