
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for pie chart
pie_labels = ["Christianity", "Islam", "Hinduism", "Buddhism", "Judaism", "Others"]
pie_sizes = [31.2, 24.1, 15.0, 7.1, 0.2, 22.4]
pie_counts = [312, 241, 150, 71, 2, 224]

# Data for stacked bar chart
bar_labels = ["Regular attendance", "Occasional attendance", "Rare attendance"]
bar_sizes = [40, 35, 25]
bar_counts = [240, 210, 150]

# Labels and Titles
title_pie = "Global Religious Demographics"
title_bar = "Attendance Rates at Religious Services"
bar_legend_labels = ["Regular", "Occasional", "Rare"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define Colors
pie_colors = ["#8dd3c7", "#ffffb3", "#bebada", "#fb8072", "#80b1d3", "#fdb462"]
bar_colors = ["#3182bd", "#6baed6", "#9ecae1"]

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6), gridspec_kw={"width_ratios": [2, 1]})

# Pie chart
ax1.pie(
    pie_sizes,
    labels=pie_labels,
    colors=pie_colors,
    autopct=lambda p: "{:.1f}%\n({})".format(p, int(round(p * sum(pie_counts) / 100))),
    startangle=140,
    wedgeprops={"edgecolor": "k", "linewidth": 1}
)
ax1.axis("equal")
ax1.set_title(title_pie)

# Stacked bar chart
bar_positions = [0]  # Single bar at position 0
bottom = 0  # Initial bottom is 0 for the first bar segment

for size, color, count, bar_label in zip(bar_sizes, bar_colors, bar_counts, bar_labels):
    ax2.bar(
        bar_positions,
        [size],
        color=color,
        edgecolor="k",
        bottom=[bottom],
        label=bar_label,
        width=0.3,
    )
    mid_pos = bottom + (size / 2)
    ax2.text(
        0,
        mid_pos,
        "{}%".format(size),
        color="black",
        ha="center",
        va="center",
    )
    bottom += size

ax2.set_axis_off()
ax2.set_title(title_bar)
ax2.legend(bar_legend_labels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_73.pdf", bbox_inches="tight")
