
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
countries = ["USA", "Germany", "China", "India"]
growth_rates = [2.9, 1.6, 6.1, 5.8]
inflation_rates = [2.3, 1.5, 2.7, 3.4]

# Axes Limits and Labels
ax1_title = "Average Growth Rates by Country"
ax1_ylim = [0, 7]
ax1_ylabel = "Growth Rate (%)"
ax2_title = "Average Inflation Rates by Country"
ax2_ylim = [0, 4]
ax2_ylabel = "Inflation Rate (%)"
sublabel_title = "Economic Indicators by Country"
legendlabels = ["Growth Rate", "Inflation Rate"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Bar chart for Average Growth Rates
ax1.bar(countries, growth_rates, color="#76c7c0")
ax1.plot(countries, growth_rates, marker="^", linestyle="--", color="#005f73", linewidth=2)
for i, rate in enumerate(growth_rates):
    ax1.text(i, rate, f"{rate:.1f}%", ha="center", va="bottom", color="#0a9396")
ax1.set_title(ax1_title)
ax1.set_ylim(ax1_ylim)
ax1.set_ylabel(ax1_ylabel)
ax1.set_facecolor("#e0fbfc")

# Bar chart for Average Inflation Rates
ax2.bar(countries, inflation_rates, color="#98c1d9")
ax2.plot(countries, inflation_rates, marker="s", linestyle=":", color="#3d5a80", linewidth=2)
for i, rate in enumerate(inflation_rates):
    ax2.text(i, rate, f"{rate:.1f}%", ha="center", va="bottom", color="#293241")
ax2.set_title(ax2_title)
ax2.set_ylim(ax2_ylim)
ax2.set_ylabel(ax2_ylabel)
ax2.set_facecolor("#e0fbfc")

# Setting a supertitle
fig.suptitle(sublabel_title, fontsize=14)

# Adding legends
ax1.legend([legendlabels[0]], loc="upper left")
ax2.legend([legendlabels[1]], loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("CB_80.pdf", bbox_inches="tight")
