
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
time_months = np.array([1, 2, 3, 4, 5, 6])
treatment_a = np.array([70, 75, 76, 78, 80, 82])
treatment_b = np.array([68, 72, 74, 77, 79, 81])
error = np.array([2, 1.5, 1.8, 1.2, 1.5, 1.6])

xlabel = "Time (Months)"
ylabel = "Effectiveness (%)"
title = "Effectiveness of Treatments Over Time"
legend_treatment_a = "Treatment A"
legend_treatment_b = "Treatment B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size to 576x432 pixels

# Treatment A
ax.plot(
    time_months,
    treatment_a,
    marker="s",
    linestyle="--",
    color="#2ca02c",
    label=legend_treatment_a,
)
ax.fill_between(
    time_months, treatment_a - error, treatment_a + error, color="#b2df8a", alpha=0.3
)

# Treatment B
ax.plot(
    time_months,
    treatment_b,
    marker="^",
    linestyle="-.",
    color="#ff7f0e",
    label=legend_treatment_b,
)
ax.fill_between(
    time_months, treatment_b - error, treatment_b + error, color="#ffbb78", alpha=0.3
)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim(0, 7)
ax.set_ylim(65, 85)
ax.legend(loc="lower right")
ax.grid(True)
ax.set_xticks(time_months)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_82.pdf", bbox_inches="tight")
