
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Data: CO2 Reduction Techniques and Effectiveness
technique_years = np.array([1, 2, 3, 4, 5, 6, 7, 8])
effectiveness = np.array([12, 25, 31, 45, 49, 56, 64, 70])
baseline_reduction = np.array([20])
error = np.array([3])

# Labels and Titles
xlabel = "Years"
ylabel = "CO2 Reduction (%)"
title = "Effectiveness of CO2 Reduction Techniques Over Time"
errorbar_label = "Baseline Reduction"
line_label = "Technique Effectiveness"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(6, 4))  # Adjusting figure size to 432x288 pixels

# Technique Effectiveness
ax.plot(
    technique_years,
    effectiveness,
    marker="s",
    color="green",
    linestyle="--",
    linewidth=2,
    label=line_label,
)
ax.fill_between(
    technique_years, effectiveness - 3, effectiveness + 3, color="#b3ffb3", alpha=0.4
)

# Baseline Reduction
ax.errorbar(
    technique_years[0],
    baseline_reduction,
    yerr=error,
    fmt="o",
    color="brown",
    label=errorbar_label,
    capsize=5,
)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim(0, 9)
ax.set_ylim(0, 80)
ax.legend(loc="upper left")
ax.grid(True)
ax.set_xticks(technique_years)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_84.pdf", bbox_inches="tight")
