
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
years = [1800, 1850, 1900, 1950, 2000]
temp_18th_century = [13.5, 13.6, 13.7, 13.9, 14.2]
temp_19th_century = [14.0, 14.2, 14.5, 14.8, 15.0]
models_18th_century = ["1800 A.D", "1850 A.D", "1900 A.D", "1950 A.D", "2000 A.D"]
models_19th_century = ["1800 B.D", "1850 B.D", "1900 B.D", "1950 B.D", "2000 B.D"]
labels = ["18th Century", "19th Century"]
ylabel = "Average Temperature (°C)"
xlabel = "Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size to match new dimensions
ax.plot(years, temp_18th_century, "--o", label=labels[0], color="#FA8072", markersize=8, linewidth=2)
ax.plot(years, temp_19th_century, "-.*", label=labels[1], color="#FF6347", markersize=10, linewidth=2)

# Annotating data points
for i, txt in enumerate(models_18th_century):
    ax.annotate(f"{temp_18th_century[i]}°C\n{txt}", (years[i], temp_18th_century[i]), textcoords="offset points", xytext=(0, 10), ha="center")

for i, txt in enumerate(models_19th_century):
    ax.annotate(f"{temp_19th_century[i]}°C\n{txt}", (years[i], temp_19th_century[i]), textcoords="offset points", xytext=(0, 10), ha="center")

# Legend
ax.legend(loc="upper left")

# Labels and Title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title('Historical Average Temperature Trends')
ax.set_yticks(np.arange(13.0, 15.5, 0.5))
ax.set_ylim([13.0, 15.5])
ax.set_xlim([1790, 2010])

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_86.pdf", bbox_inches="tight")
