
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for the line plot
data_model_1 = np.random.normal(1, 0.8, 100)
data_model_2 = np.random.normal(2, 1, 100)
data_model_3 = np.random.normal(1.5, 0.9, 100)

kde_model_1 = gaussian_kde(data_model_1)
kde_model_2 = gaussian_kde(data_model_2)
kde_model_3 = gaussian_kde(data_model_3)

x_range = np.linspace(-2, 5, 100)
labels = ["Model A", "Model B", "Model C"]
title = "Model Comparison"
xlabel = "Accuracy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific size
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 6), gridspec_kw={"height_ratios": [3, 2]})

# Line plot with enhanced style
ax1.fill_between(x_range, kde_model_1(x_range), color="#FFDDC1", alpha=0.4)
ax1.fill_between(x_range, kde_model_2(x_range), color="#D4A5A5", alpha=0.5)
ax1.fill_between(x_range, kde_model_3(x_range), color="#A1C6EA", alpha=0.3)
ax1.plot(x_range, kde_model_1(x_range), label=labels[0], color="#FF5733", linestyle="--", linewidth=2)
ax1.plot(x_range, kde_model_2(x_range), label=labels[1], color="#C70039", linestyle="-.", linewidth=2)
ax1.plot(x_range, kde_model_3(x_range), label=labels[2], color="#581845", linestyle=":", linewidth=2)
ax1.legend(title=title, loc="upper right")
ax1.set_xticks([])
ax1.set_yticks([])

# Box plot with enhanced style
box = ax2.boxplot(
    [data_model_1, data_model_2, data_model_3], vert=False, patch_artist=True, medianprops={"color": "black"}
)
box_colors = ["#FF5733", "#C70039", "#581845"]
for patch, color in zip(box["boxes"], box_colors):
    patch.set_facecolor(color)

ax2.set_xlabel(xlabel)
ax2.set_yticks([])
ax2.set_xlim(-2, 5)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("CB_92.pdf", bbox_inches="tight")
