
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import norm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate data for basketball player stats
points_data = np.random.normal(25, 7, 1000)
assists_data = np.random.normal(7, 3, 1000)
rebounds_data = np.random.normal(10, 4, 1000)
steals_data = np.random.normal(2, 1, 1000)
titles = ["Points Scored", "Assists", "Rebounds", "Steals"]
xlabels = [
    "Daily points",
    "Daily assists",
    "Daily rebounds",
    "Daily steals",
]
ylabels = ["Probability", "Probability", "Probability", "Probability"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 8))

# Define the subplot grid with reduced space between subplots
grid = plt.GridSpec(2, 2, wspace=0.4, hspace=0.5)

# Points Scored subplot
ax_points = plt.subplot(grid[0, 0])
ax_points.hist(
    points_data, bins=20, color="#2171b5", edgecolor="black", density=True, linewidth=1
)
ax_points.plot(
    np.sort(points_data),
    norm.pdf(np.sort(points_data), np.mean(points_data), np.std(points_data)),
    color="#fdae61",
)
ax_points.set_title(titles[0])
ax_points.set_xlabel(xlabels[0])
ax_points.set_ylabel(ylabels[0])
ax_points.set_ylim(0, 0.060)
ax_points.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(points_data):.2f}$\n$\sigma = {np.std(points_data):.2f}$",
    transform=ax_points.transAxes,
    fontsize=9,
)

# Assists subplot
ax_assists = plt.subplot(grid[0, 1])
ax_assists.hist(
    assists_data,
    bins=20,
    color="#e31a1c",
    edgecolor="black",
    density=True,
    linewidth=1,
)
ax_assists.plot(
    np.sort(assists_data),
    norm.pdf(np.sort(assists_data), np.mean(assists_data), np.std(assists_data)),
    color="#fdae61",
)
ax_assists.set_title(titles[1])
ax_assists.set_xlabel(xlabels[1])
ax_assists.set_ylabel(ylabels[1])
ax_assists.set_ylim(0, 0.15)
ax_assists.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(assists_data):.2f}$\n$\sigma = {np.std(assists_data):.2f}$",
    transform=ax_assists.transAxes,
    fontsize=9,
)

# Rebounds subplot
ax_rebounds = plt.subplot(grid[1, 0])
ax_rebounds.hist(
    rebounds_data,
    bins=20,
    color="#33a02c",
    edgecolor="black",
    density=True,
    linewidth=1,
)
ax_rebounds.plot(
    np.sort(rebounds_data),
    norm.pdf(np.sort(rebounds_data), np.mean(rebounds_data), np.std(rebounds_data)),
    color="#fdae61",
)
ax_rebounds.set_title(titles[2])
ax_rebounds.set_xlabel(xlabels[2])
ax_rebounds.set_ylabel(ylabels[2])
ax_rebounds.set_ylim(0, 0.10)
ax_rebounds.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(rebounds_data):.2f}$\n$\sigma = {np.std(rebounds_data):.2f}$",
    transform=ax_rebounds.transAxes,
    fontsize=9,
)

# Steals subplot
ax_steals = plt.subplot(grid[1, 1])
ax_steals.hist(
    steals_data, bins=20, color="#ff7f00", edgecolor="black", density=True, linewidth=1
)
ax_steals.plot(
    np.sort(steals_data),
    norm.pdf(np.sort(steals_data), np.mean(steals_data), np.std(steals_data)),
    color="#fdae61",
)
ax_steals.set_title(titles[3])
ax_steals.set_xlabel(xlabels[3])
ax_steals.set_ylabel(ylabels[3])
ax_steals.set_ylim(0, 0.6)
ax_steals.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(steals_data):.2f}$\n$\sigma = {np.std(steals_data):.2f}$",
    transform=ax_steals.transAxes,
    fontsize=9,
)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_94.pdf", bbox_inches="tight")
