
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
x = [5, 10, 15, 20, 25]
y = [15.2, 15.5, 15.7, 15.8, 15.85]
x2 = [30]
y2 = [15.9]

# Labels and Plot Types
label_Solar_Panel_Set_1 = "Set 1"
label_Solar_Panel_Set_2 = "Set 2"
ax1_txt = [
    "15.2%\n5 panels",
    "15.5%\n10 panels",
    "15.7%\n15 panels",
    "15.8%\n20 panels",
    "15.85%\n25 panels",
]
ax2_txt = "15.9%\n30 panels"

# Axes Limits and Labels
xlabel_value = "Number of Solar Panels Installed"
ylabel_value = "Efficiency (%)"
xticklabels1 = [str(num) for num in x]
ylim_values = [15.0, 16.0]
yticks_values = [15.0, 15.2, 15.4, 15.6, 15.8, 16.0]
xlim_values = [0, 35]
xticks_values = [0, 10, 20, 30]
xticklabels2 = ["0", "10", "20", "30"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 8))

# Plot the data
ax.plot(x, y, "g^-", label=label_Solar_Panel_Set_1, linewidth=2, markersize=8)
ax.plot(x2, y2, "bs", markersize=10, label=label_Solar_Panel_Set_2)

# Annotate the points
for i, txt in enumerate(ax1_txt):
    ax.annotate(
        txt,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
ax.annotate(
    ax2_txt,
    (x2[0], y2[0]),
    textcoords="offset points",
    xytext=(0, 5),
    ha="center",
    color="black",
    fontsize=10,
)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=10)
ax.set_ylabel(ylabel_value, fontsize=10)
ax.set_title("Solar Panel Efficiency vs. Number of Panels")

# Set the legend
legend = ax.legend(fontsize=10)

# Adjust x-axis labels
ax.set_xticks(x)
ax.set_xticklabels(xticklabels1, ha="center")
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xlim(xlim_values)
ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels2, ha="center")

# Add grid lines for clarity
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("CB_97.pdf", bbox_inches="tight")
